package {
	
	import away3d.containers.ObjectContainer3D;
	import away3d.core.base.Mesh;
	import away3d.events.LoaderEvent;
	import away3d.loaders.Collada;
	import away3d.loaders.Object3DLoader;
	import away3d.materials.PhongBitmapMaterial;
	import away3d.materials.WhiteShadingBitmapMaterial;
	
	import com.flashdynamix.motion.Tweensy;
	import com.flashdynamix.motion.TweensyTimeline;
	
	import fl.motion.easing.Cubic;
	
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.events.Event;
	import flash.system.System;
	
	import org.libspark.thread.Monitor;
	import org.libspark.thread.utils.EventDispatcherThread;

	public class HachuneDemo extends EventDispatcherThread implements IDemoThread {
		
		[Embed(source='../bin-debug/models/miku.png')]
		private static const hachuneTexClass:Class;
		private static const hachuneTex:BitmapData = Bitmap(new hachuneTexClass()).bitmapData;
		
		private var _ctx:Context;
		private static var _hachune:Object3DLoader;
		private var _anime:TweensyTimeline;
		private var _monitor:Monitor;

		public function HachuneDemo(ctx:Context) {
			this._ctx = ctx;
		}
		
		protected override function run():void {
			if (!_hachune) {
				var mat:WhiteShadingBitmapMaterial = new WhiteShadingBitmapMaterial(hachuneTex);
	//			var mat:PhongBitmapMaterial = new PhongBitmapMaterial(hachuneTex);
				_hachune = Collada.load('models/hachune.dae', {material:mat});
				_hachune.scale(0.05);
				this._ctx.arview.marker.addChild(_hachune);
				event(_hachune, LoaderEvent.LOAD_SUCCESS, this._onLoaded);
			} else {
				this._ctx.arview.marker.addChild(_hachune.handle);
				this._onLoaded(null);
			}
		}
		
		private function _onLoaded(e:Event):void {
			var mesh:Mesh = ObjectContainer3D(_hachune.handle).children[0];
			this._anime = Tweensy.fromTo(mesh, {rotationX:-20}, {rotationX:20}, 0.3, Cubic.easeInOut);
			this._anime.repeatType = TweensyTimeline.YOYO;
			this._anime.repeatCount = 0;
			this._monitor = new Monitor();
			this._monitor.wait();
		}

		public function close():void {
			if (this._monitor) {
				this._monitor.notifyAll();
				this._anime.stopAll();
				this._anime = null;
			}
		}
		
		protected override function finalize():void {
			this._ctx.arview.marker.removeChild(_hachune.handle);
			this._ctx = null;
//			this._hachune = null;
//			System.gc();
		}
	}
}